//--------------------------------------------------------------------------------------
// File: BasicHLSL.fx
//
// The effect file for the BasicHLSL sample.  
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
//--------------------------------------------------------------------------------------

float3 LightPosition;//̍W
float3 g_LightDir;//̌
float4 g_LightDiffuse;//̐F
float4 g_SpeculurPower;//ˌ

float3 m_EyePos;//JW

float4 DiffuseColor;//}eAF
float4 EmissiveColor;//}eA̔F
texture g_MeshTexture;//}eAƂ̃eNX`
//ϊs
float4x4 World;
float4x4 View;
float4x4 Projection;

float4x4 matLightView;//Cgr[
float4x4 matLightProj;//ˉeϊs

//eNX`]p
float tex_uv_timer;
//vC[̃[hW
float3 player_pos;
//̗ւ̑傫
float ring_scale;

//J̃Nbv
float3 clip_max_min;

texture texShadowMap;// VhE}bveNX`
sampler DefSampler = sampler_state// Tv[Xe[g
{
    texture = (texShadowMap);
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW = CLAMP;
    
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
    
};

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler MeshTextureSampler = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//-----------------------------------------------------------------------------
// Cӂ̉]ŉ]NH[^jI̐
//=============================================================================
float4 QuaternionFromAxisAngle( float3 axis, float angle)
{
	float halfAngle = angle * 0.5f;
	return float4( axis * sin(halfAngle), cos(halfAngle));
}

//-----------------------------------------------------------------------------
// NH[^jIɂ钸_ϊ
//=============================================================================
float3 TransformByQuaternion( float3 position, float4 quaternion)
{
	float4 Q = quaternion;
	float3 v = position;
	
	return 
		( 2.0f * Q.w * Q.w - 1.0f ) * v +
		( 2.0f * dot( v, Q.xyz ) * Q.xyz ) +
		( 2.0f * Q.w * cross( Q.xyz, v ) );
}
//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV  : TEXCOORD0;  // vertex texture coords 
    float4 ZCalcTex  : TEXCOORD1;  // vertex texture coords
};
struct VS_OUTPUT_N
{
    float4 Position   : POSITION;   // vertex position
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV  : TEXCOORD0;  // vertex texture coords 
    float4 ZCalcTex  : TEXCOORD1;  // vertex texture coords
    float3 Normal   : TEXCOORD2;   // vertex Normal
    float3 world_pos   : TEXCOORD3;   // vertex W
};
struct VS_OUTPUT_Z
{
    float4 Position   : POSITION;   // vertex position
    float4 TextureUV  : TEXCOORD0;  // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
    //float4 viewPosition = mul(worldPosition, matLightView);
    //Output.Position = mul(viewPosition, matLightProj);
    
    //@[hWn
    float3 vNormalWorldSpace;
    // Transform the normal from object space to world space    
    vNormalWorldSpace = normalize(mul(vNormal, (float3x3)World));
    
    //@_F	
	float3 L = -g_LightDir;
	float3 N = vNormalWorldSpace;
	
	float4 C = DiffuseColor;
	C.xyz = C.xyz * max(0.4f, dot(N, L));
	
	//o[g
	float4 Ia = float4(0.0f, 0.0f, 0.1f, 0.0f);//
	Output.Diffuse = Ia + g_LightDiffuse * (C + EmissiveColor);
	
	//_ -> _ ւ̃xNgvZ
    float3 E = m_EyePos - worldPosition.xyz;//viewPosition.xyz;
    float3 LPOS = LightPosition - worldPosition.xyz;
    
	//_ -> CgʒuxNg + _ -> _xNg
	float3 H = normalize(normalize(LPOS) + normalize(E));
	//XyL[J[vZ
	float3 m_SpecularColor = float3(1.0f, 0.8f, 0.2f);
	float S = pow( max( 0.0f, dot( N, H ) ), 8);
	//S = min(0.5f, S);
	S *= g_SpeculurPower.x;	

	Output.Diffuse.xyz = Output.Diffuse.xyz + m_SpecularColor * S;
    Output.Diffuse.w = 1.0f; 
    
    //tHO
    float fog = 1.0f - (max(0,viewPosition.z - 1000) / 1000.0f);//JProjɍ킹ēK
    fog = max(0.25f,fog);
    Output.Diffuse.xyz *= fog; 
    
    // Cg̖ڐɂ郏[hr[ˉeϊ
    float4x4 mat;
	mat  = mul( World, matLightView );
	mat  = mul( mat, matLightProj );
	Output.ZCalcTex = mul( vPos, mat );//Cg猩W
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
//epƂ
VS_OUTPUT RenderSceneVS_Simple( float4 vPos : POSITION,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
    //@_F	
	Output.Diffuse = DiffuseColor + EmissiveColor;
    
    // Cg̖ڐɂ郏[hr[ˉeϊ
    float4x4 mat;
	mat  = mul( World, matLightView );
	mat  = mul( mat, matLightProj );
	Output.ZCalcTex = mul( vPos, mat );//Cg猩W
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
//^[QbgTCgƂJڐZ~Ƃ
VS_OUTPUT RenderSceneVS_Cam_Z( float4 vPos : POSITION,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
    float z_val = viewPosition.z / clip_max_min.z;//J_łzlvWFNṼNbv͈͂0.0~1.0fƂď
    z_val = max(0,z_val);
    //@_F
	Output.Diffuse = float4(1.0f,1.0f,1.0f,1.0f) * z_val;
	Output.Diffuse.w = 1.0f;
    
	Output.ZCalcTex = float4(0,0,0,0);//Cg猩W͎gȂ
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
//n`p
VS_OUTPUT_N RenderSceneVS_Shadow( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT_N Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    Output.world_pos = worldPosition;
    
    //float4 viewPosition = mul(worldPosition, matLightView);
    //Output.Position = mul(viewPosition, matLightProj);
    
    //@[hWn
    float3 vNormalWorldSpace;
    // Transform the normal from object space to world space    
    vNormalWorldSpace = normalize(mul(vNormal, (float3x3)World));
    
    //@_F	
	float3 L = -g_LightDir;
	float3 N = vNormalWorldSpace;
	
	
	Output.Normal = N;


	float4 C = DiffuseColor;
	C.xyz = C.xyz * max(0.4f, dot(N, L));
	
	//o[g
	float4 Ia = float4(0.0f, 0.0f, 0.1f, 1.0f);//
	Output.Diffuse = Ia + g_LightDiffuse * (C + EmissiveColor);
	//Output.Diffuse = Ia + g_LightDiffuse * C + EmissiveColor;
	
	//_ -> _ ւ̃xNgvZ
    float3 E = m_EyePos - worldPosition.xyz;//viewPosition.xyz;
    float3 LPOS = LightPosition - worldPosition.xyz;
    
	//_ -> CgʒuxNg + _ -> _xNg
	float3 H = normalize(normalize(LPOS) + normalize(E));
	//XyL[J[vZ
	float3 m_SpecularColor = float3(1.0f, 0.8f, 0.2f);
    	float S = pow( max( 0.0f, dot( N, H ) ), 8);
	S *= g_SpeculurPower.y;	
	Output.Diffuse.xyz = Output.Diffuse.xyz + m_SpecularColor * S;
    Output.Diffuse.w = DiffuseColor.w; 
    
    //tHO
    float fog = 1.0f - (max(0,viewPosition.z - 1000) / 1000.0f);//JProjɍ킹ēK
    fog = max(0.25f,fog);
    Output.Diffuse.xyz *= fog; 
    
    // Cg̖ڐɂ郏[hr[ˉeϊ
    float4x4 mat;
	mat  = mul( World, matLightView );
	mat  = mul( mat, matLightProj );
	Output.ZCalcTex = mul( vPos, mat );//Cg猩W
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
//Zp
VS_OUTPUT RenderSceneVS_EMI( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
	//G~bVû܂ܓfo
	Output.Diffuse = EmissiveColor;
	
	//tHO
    float fog = 1.0f - (max(0,viewPosition.z - 1200) / 1000.0f);//G~bVuptHO
    fog = max(0.5f,fog);
    Output.Diffuse.xyz *= fog;
    
    Output.TextureUV = vTexCoord0; 
    
    Output.ZCalcTex = Output.Position;
    
    return Output;    
}
//}bvip
VS_OUTPUT RenderSceneVS_EMI_EX( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
	//G~bVû܂ܓfo
	Output.Diffuse = EmissiveColor;
	
	//tHO
    float fog = 1.0f - (max(0,viewPosition.z - 1000) / 3000.0f);//G~bVuptHO
    fog = max(0.1f,fog);
    Output.Diffuse.yz *= fog; 
    
    // ̓eNX`W]ϊ
    float3 TC = float3(vTexCoord0.x - 0.5f,vTexCoord0.y - 0.5f,0);
    //Y
    float4 TR = QuaternionFromAxisAngle( float3(0,0,1), tex_uv_timer);
    TC = TransformByQuaternion( TC, TR );
    
    Output.TextureUV = float2(TC.x + 0.5f,TC.y + 0.5f);
	//Output.TextureUV = vTexCoord0; 
	
    Output.ZCalcTex = Output.Position;
    
    return Output;    
}
//fvXVhEpBZl̏
VS_OUTPUT_Z RenderSceneVS_Z( float4 vPos : POSITION)
{
    VS_OUTPUT_Z Output;
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, matLightView);
    Output.Position = mul(viewPosition, matLightProj);
    
    Output.TextureUV = Output.Position; 
    
    return Output;    
}
VS_OUTPUT RenderSceneVS_MAP( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
    //float4 viewPosition = mul(worldPosition, matLightView);
    //Output.Position = mul(viewPosition, matLightProj);
    
    //@[hWn
    float3 vNormalWorldSpace;
    // Transform the normal from object space to world space    
    vNormalWorldSpace = normalize(mul(vNormal, (float3x3)World));
    
    //@_F	
	float3 L = -g_LightDir;
	float3 N = vNormalWorldSpace;
	float4 C = DiffuseColor;
	//C.xyz = C.xyz * max(0.4f, dot(N, L));
	
	//o[g
	float4 Ia = float4(0.0f, 0.0f, 0.1f, 1.0f);//
	Output.Diffuse = Ia + g_LightDiffuse * (C + EmissiveColor);
	//Output.Diffuse = Ia + g_LightDiffuse * C + EmissiveColor;
	
	Output.Diffuse *= 0.5f + (worldPosition.y / 500.0f);
    Output.Diffuse.w = 1.0f; 
    
    // Cg̖ڐɂ郏[hr[ˉeϊ
    float4x4 mat;
	mat  = mul( World, matLightView );
	mat  = mul( mat, matLightProj );
	Output.ZCalcTex = mul( vPos, mat );//Cg猩W
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
VS_OUTPUT RenderSceneVS_MAP_MARKER( float4 vPos : POSITION, 
                         float3 vNormal : NORMAL,
                         float2 vTexCoord0 : TEXCOORD0)
{
    VS_OUTPUT Output;
    
    
    //[JWvWFNVW
    float4 worldPosition = mul(vPos, World);
    float4 viewPosition = mul(worldPosition, View);
    Output.Position = mul(viewPosition, Projection);
    
    //float4 viewPosition = mul(worldPosition, matLightView);
    //Output.Position = mul(viewPosition, matLightProj);
    
    //@[hWn
    float3 vNormalWorldSpace;
    // Transform the normal from object space to world space    
    vNormalWorldSpace = normalize(mul(vNormal, (float3x3)World));
    
    //@_F	
	float3 L = -g_LightDir;
	float3 N = vNormalWorldSpace;
	float4 C = DiffuseColor;
	C.xyz = C.xyz * max(0.4f, dot(N, L));
	
	//o[g
	float4 Ia = float4(0.0f, 0.0f, 0.1f, 1.0f);//
	Output.Diffuse = Ia + g_LightDiffuse * C + EmissiveColor;
    Output.Diffuse.w = 1.0f; 
    
    // Cg̖ڐɂ郏[hr[ˉeϊ
    float4x4 mat;
	mat  = mul( World, matLightView );
	mat  = mul( mat, matLightProj );
	Output.ZCalcTex = mul( vPos, mat );//Cg猩W
    
    Output.TextureUV = vTexCoord0; 
    
    return Output;    
}
//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};

//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
PS_OUTPUT RenderScenePS( VS_OUTPUT In) 
{ 
    PS_OUTPUT Output;
	
    //ʏ̐FvZ
    Output.RGBColor = tex2D(MeshTextureSampler, In.TextureUV) * In.Diffuse;
    Output.RGBColor.w *= DiffuseColor.w;
    
    return Output;
}
PS_OUTPUT RenderScenePS_Shadow( VS_OUTPUT_N In) 
{ 
    PS_OUTPUT Output;

	// CgڐɂZl̍ĎZo
    float ZValue = In.ZCalcTex.z / In.ZCalcTex.w;
    
    // eNX`Wɕϊ
	float2 TransTexCoord;
	TransTexCoord.x = (1.0f + In.ZCalcTex.x/In.ZCalcTex.w)*0.5f;
	TransTexCoord.y = (1.0f - In.ZCalcTex.y/In.ZCalcTex.w)*0.5f;
	
	// WZl𒊏o
	float SM_Z = tex2D( DefSampler, TransTexCoord ).x;
	
    //ʏ̐FvZ
    Output.RGBColor = tex2D(MeshTextureSampler, In.TextureUV) * In.Diffuse;
    //Output.RGBColor = In.Diffuse;
    
    // Zo_VhE}bvZl傫ΉeƔf
	if( ZValue > SM_Z+0.005f )
	{
		Output.RGBColor.rgb = Output.RGBColor.rgb * 0.5f;
	}
	
	//vC[̒nn_𔭌
	float3 dp = In.world_pos - player_pos;

	float dl_pow = length(float3(dp.x, 0, dp.z));//y𖳎傫
	float l_border = 30 * ring_scale;
	float ddp = max(1.0f,abs(dl_pow - l_border * 0.85f) * ring_scale);
	
	//n_̓
	float ddp_2 = min(1.0f , abs(max(0,l_border  * 0.85f - dl_pow))) * 0.04f;
	ddp_2 *= 1.0f + 0.1 * ring_scale;
	
	//vC[̐^͋
	ddp_2 = min(1.0f, ddp_2 + 1 / (abs(dl_pow) * 0.75f + 1) * ring_scale);
	
	//vC[荂n`͔Ȃ	
	float py_hight = max(0, dot(normalize(dp), In.Normal));
	py_hight = 1.0f - min(1.0f, py_hight * 1000);
	
	//vC[Ɛʂɋ
	float py_light = max(0.0f, dot(In.Normal, float3(0,1,0)));
	
	
	Output.RGBColor.rgb += float3(1.0f,-0.5f,-0.5f) * (1 / ddp * ring_scale + ddp_2 * py_light) * py_hight;

    
    return Output;
}
//eNX`Ȃ
PS_OUTPUT RenderScenePS_NONTEX( VS_OUTPUT In) 
{ 
    PS_OUTPUT Output;
    
    Output.RGBColor = In.Diffuse;
    Output.RGBColor.w *= DiffuseColor.w;
    
    return Output;
}
//Zobt@p
PS_OUTPUT RenderScenePS_Z( VS_OUTPUT_Z In) 
{ 
    PS_OUTPUT Output;
    
    Output.RGBColor = In.TextureUV.z / In.TextureUV.w;
    
    return Output;
}
//J_Zobt@p
PS_OUTPUT RenderScenePS_Cam_Z( VS_OUTPUT In) 
{ 
    PS_OUTPUT Output;
    
    Output.RGBColor = In.Diffuse;
    Output.RGBColor.w *= DiffuseColor.x;
    
    return Output;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Render//ftHg
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}
technique Render_Sadow//e𗎂Ƃ^CṽIuWFNgBn`ƂB
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_Shadow();
        PixelShader  = compile ps_2_0 RenderScenePS_Shadow();
    }
}
technique Render_EMI//
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_EMI();
        PixelShader  = compile ps_2_0 RenderScenePS_NONTEX();
    }
}
technique Render_EMI_EX//{eNX`
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_EMI_EX();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}
technique Z_BUF//fvXVhEp
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_Z();
        PixelShader  = compile ps_2_0 RenderScenePS_Z();
    }
}
technique Render_Map//n}p
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_MAP();
        PixelShader  = compile ps_2_0 RenderScenePS_NONTEX();
    }
}
technique Render_Map_Marker//n}}[J[p
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_MAP_MARKER();
        PixelShader  = compile ps_2_0 RenderScenePS_NONTEX();
    }
}
technique Render_Map_Marker_TEX//n}}[J[ŃeNX`t
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_MAP_MARKER();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}
technique Render_Simple//epƂ
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_Simple();
        PixelShader  = compile ps_2_0 RenderScenePS_NONTEX();
    }
}
technique Render_Cam_Z//JZ
{
    pass P0
    {          
        VertexShader = compile vs_2_0 RenderSceneVS_Cam_Z();
        PixelShader  = compile ps_2_0 RenderScenePS_Cam_Z();
    }
}